﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using FTD2XX_NET;

namespace MNET_STK_IO_Sample
{
    public partial class Form1 : Form
    {
        ////////////////////////////////////////////////////////////////////
        /// <summary>
        ///     Version Information
        /// </summary>
        // public string Version = "1.00";
        // string VerDate = "2020.02.12";

        ////////////////////////////////////////////////////////////////////
        private Label[] Port0_Labels;   // Container for arranging labels of Port0 to be displayed
        private Button[] Port1_Buttons; // Container for arranging buttons of Port1 to be displayed
        private Button[] Port2_Buttons; // Container for arranging buttons of Port2 to be displayed
        private Button[] Port3_Buttons; // Container for arranging buttons of Port3 to be displayed

        private Color[] bitons = { Color.Lime, Color.Red, Color.Lime, Color.Blue };                 // Label & Button color when ON
        private Color[] bitoffs = { Color.DarkGreen, Color.DarkRed, Color.DarkRed, Color.DarkRed }; // Label & Button color when OFF

        private byte[] Devinf_D;        // Keep Device Information value of 64 devices
        private uint[] Attr_D;          // Keep Attribute value of 64 devices
        private uint Status;            // Value of G9001A Status
        private uint IntStatus;         // Value of G9001A Interrupt Status
        private byte dno;               // Device Number

        private byte port0;             // Keep G9002A Port0 value
        private byte port1;             // Keep G9002A Port1 value
        private byte port2;             // Keep G9002A Port2 value
        private byte port3;             // Keep G9002A Port3 value
        private byte port1s;            // Save G9002A Port1 value
        private byte port2s;            // Save G9002A Port2 value
        private byte port3s;            // Save G9002A Port3 value
        private byte[] portrd;          // Port Read Buffer

        private int chkloop;            // Waiting loop
        private int CommFlag = 0;       // Timer processing flag

        ////////////////////////////////////////////////////////////////////
        private clsFTDI hFTDI = new clsFTDI();
        private accessMNET hMNET = new accessMNET();
        FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
        ////////////////////////////////////////////////////////////////////

        public Form1()
        {
            InitializeComponent();
            this.MaximizeBox = false;   // Not maximize
        }

        /// <summary>
        /// Software startup processing
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Form1_Load(object sender, EventArgs e)
        {
            // Arranged in the center of the screen
            this.Left = (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width - this.Width) / 2;
            this.Top = (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Height - this.Height) / 2;
            this.StartPosition = FormStartPosition.Manual;

            // Labels & Buttons arrangement
            Port0_Labels = new Label[] { b_i00, b_i01, b_i02, b_i03, b_i04, b_i05, b_i06, b_i07 };
            Port1_Buttons = new Button[] { b_o10, b_o11, b_o12, b_o13, b_o14, b_o15, b_o16, b_o17 };
            Port2_Buttons = new Button[] { b_o20, b_o21, b_o22, b_o23, b_o24, b_o25, b_o26, b_o27 };
            Port3_Buttons = new Button[] { b_o30, b_o31, b_o32, b_o33, b_o34, b_o35, b_o36, b_o37 };

            // All(64) Device
            Devinf_D = new byte[]  { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 00-15
                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 16-31
                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 32-47
                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }; // 48-63

            Attr_D = new uint[]   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    // 00-15
                                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    // 16-31
                                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    // 32-47
                                    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };  // 48-63
            // One Device
            portrd = new byte[] { 0, 0, 0, 0 };

            ////////////////////////////////////////////////////////////////////
            ftStatus = hFTDI.LSI_Open("NPM G9001A-EV Paralell access A");

            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                MessageBox.Show(" G9001A not found" + Environment.NewLine + " Connect Motionnet Stater Kit!", "Error");
                Close();
            }

            ftStatus = hMNET.MNETCenterComdWriteSoftwareReset(); // Software Reset Command
            chkloop = 1; // Waiting loop set
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                goto END;
            }
            else
            {
                while (chkloop != 0)
                {
                    ftStatus = hMNET.MNETCenterReadSts(ref Status, ref IntStatus); // Read Status 
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        goto END;
                    }
                    if ((Status & 0x2000) == 0) // RBSY check
                    {
                        chkloop = 0; // Reset processing completed
                    }
                }
            }
            ftStatus = hMNET.MNETCenterComdWriteSystemComm(); // System communication Command
            chkloop = 1; // Waiting loop set
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                goto END;
            }
            else
            {
                while (chkloop != 0)
                {
                    ftStatus = hMNET.MNETCenterReadSts(ref Status, ref IntStatus); // Read Status
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        goto END;
                    }
                    if ((Status & 0x0001) == 1) // CEND check
                    {
                        chkloop = 0; // Reset processing completed
                    }
                }
            }
            ftStatus = hMNET.MNETCenterComdWriteCyclicComm(); // Start cyclic communication Command
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                goto END;
            }

            // G9002A(IN8/OUT24) Search
            Device_Search();

            // Port Data R/W
            Port_Data_Read();
            Port_Data_Out();

            // Initial Port Display
            port0 = portrd[0];
            InputPort0_Set(port0);
            port1 = portrd[1];
            port1s = port1;
            OutputPort1_Set(port1);
            port2 = portrd[2];
            port2s = port2;
            OutputPort2_Set(port2);
            port3 = portrd[3];
            port3s = port3;
            OutputPort3_Set(port3);

            CommFlag = 1;
            this.timer1.Start();

END:
            FTDI_processing();
        }

        /// <summary>
        /// Software termination processing
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            hFTDI.LSI_Close();
        }

        /// <summary>
        /// FTDI processing
        /// </summary>
        private void FTDI_processing()
        {
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                this.timer1.Stop();
                MessageBox.Show(" FTDI Commucation Error" + Environment.NewLine + " Check USB connector connection!", "Error");
                Close();
            }
        }

        /// <summary>
        /// Device Search [G9002A(IN8/OUT24)]
        /// </summary>
        private void Device_Search()
        {
            int loops;
            int chk = 0;

            // Address Map Device Information All Read
            for (loops = 0; loops < 64; loops++)
            {
                dno = (byte)loops;
                ftStatus = hMNET.MNETCenterReadInf(dno, ref Devinf_D);
                if (ftStatus != FTDI.FT_STATUS.FT_OK)
                {
                    goto END;
                }
            }

            // Device Information Command All Read
//            byte rdataA = 0, rdataB = 0;
//            for (loops = 0; loops < 32; loops++)
//            {
//                dno = (byte)(loops * 2);
//                ftStatus = hMNET.MNETCenterComdReadDevInf(dno, ref rdataA, ref rdataB);
//                if (ftStatus != FTDI.FT_STATUS.FT_OK)
//                {
//                    goto END;
//                }
//                else
//                {
//                    Devinf_D[dno + 0] = rdataA;
//                    Devinf_D[dno + 1] = rdataB;
//                }
//            }

            for (loops = 0; loops < 64; loops++)
            {
                dno = (byte)loops;
                if (Devinf_D[dno] == 0x81) // G9002A(IN8/OUT24) Check
                {
                    ftStatus = hMNET.MNETCenterComdReadDevAttribute(dno); // Device Attribute Read
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        goto END;
                    }
                    while (chkloop != 0)
                    {
                        ftStatus = hMNET.MNETCenterReadSts(ref Status, ref IntStatus); // Read Status
                        if (ftStatus != FTDI.FT_STATUS.FT_OK)
                        {
                            goto END;
                        }
                        if ((Status & 0x0001) == 1) // CEND
                        {
                            chkloop = 0; // Reset processing completed
                        }
                    }
                    ftStatus = hMNET.MNETCenterComdGetDevAttribute(dno, ref Attr_D); // Device Attribute Data Get
                    if (ftStatus != FTDI.FT_STATUS.FT_OK)
                    {
                        goto END;
                    }

                    t_dno.Text = string.Format("{0:D" + 2 + "}", dno);
                    t_dinf.Text = string.Format("{0:X" + 2 + "}", Devinf_D[dno]);
                    t_dattr.Text = string.Format("{0:X" + 8 + "}", Attr_D[dno]);
                    chk = 1;
                    break;
                }
            }
            if (chk == 0)
            {
                this.timer1.Stop();
                MessageBox.Show(" G9002A(IN8/OUT24) not found" + Environment.NewLine + " Connect [ G9002A_G9103C-EV ]!", "Error");
                Close();
            }
            
END:
            FTDI_processing();
        }

        /// <summary>
        /// Device Error Check [G9002A(IN8/OUT24)]
        /// </summary>
        private void Device_Error_Check()
        {
            ftStatus = hMNET.MNETCenterReadSts(ref Status, ref IntStatus); // Read Status
            if ((Status & 0x0008) != 0) // EIOE
            {
                this.timer1.Stop();
                MessageBox.Show(" G9002A(IN8/OUT24) not found" + Environment.NewLine + " Connect [ G9002A_G9103C-EV ]!", "Error");
                Close();
            }
            FTDI_processing();
        }

        /// <summary>
        /// Port Data Read
        /// </summary>
        private void Port_Data_Read()
        {
            ftStatus = hMNET.MNETCenterComdReadPortD(dno, 0, ref portrd[0], ref portrd[1]); // Read Port0 & Port1
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                goto END;
            }

            ftStatus = hMNET.MNETCenterComdReadPortD(dno, 1, ref portrd[2], ref portrd[3]); // Read Port2 & Port3

END:
            FTDI_processing();
        }

        /// <summary>
        /// Port Data Write
        /// </summary>
        private void Port_Data_Out()
        {
            ftStatus = hMNET.MNETCenterComdWritePortD(dno, 0, port0, port1); // Write Port0 & Port1
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                goto END;
            }

            ftStatus = hMNET.MNETCenterComdWritePortD(dno, 1, port2, port3); // Write Port2 & Port3

END:
            FTDI_processing();
        }

        /// <summary>
        /// Port1 output Button Click
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void b_o10_Click(object sender, EventArgs e)
        {
            port1 = (byte)(port1 ^ 0x01); // Bit 0
            Port_Data_Out();
        }

        private void b_o11_Click(object sender, EventArgs e)
        {
            port1 = (byte)(port1 ^ 0x02); // Bit 1
            Port_Data_Out();
        }

        private void b_o12_Click(object sender, EventArgs e)
        {
            port1 = (byte)(port1 ^ 0x04); // Bit 2
            Port_Data_Out();
        }

        private void b_o13_Click(object sender, EventArgs e)
        {
            port1 = (byte)(port1 ^ 0x08); // Bit 3
            Port_Data_Out();
        }

        private void b_o14_Click(object sender, EventArgs e)
        {
            port1 = (byte)(port1 ^ 0x10); // Bit 4
            Port_Data_Out();
        }

        private void b_o15_Click(object sender, EventArgs e)
        {
            port1 = (byte)(port1 ^ 0x20); // Bit 5
            Port_Data_Out();
        }

        private void b_o16_Click(object sender, EventArgs e)
        {
            port1 = (byte)(port1 ^ 0x40); // Bit 6
            Port_Data_Out();
        }

        private void b_o17_Click(object sender, EventArgs e)
        {
            port1 = (byte)(port1 ^ 0x80); // Bit 7
            Port_Data_Out();
        }

        /// <summary>
        /// Port2 output Button Click
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void b_o20_Click(object sender, EventArgs e)
        {
            port2 = (byte)(port2 ^ 0x01); // Bit 0
            Port_Data_Out();
        }

        private void b_o21_Click(object sender, EventArgs e)
        {
            port2 = (byte)(port2 ^ 0x02); // Bit 1
            Port_Data_Out();
        }

        private void b_o22_Click(object sender, EventArgs e)
        {
            port2 = (byte)(port2 ^ 0x04); // Bit 2
            Port_Data_Out();
        }

        private void b_o23_Click(object sender, EventArgs e)
        {
            port2 = (byte)(port2 ^ 0x08); // Bit 3
            Port_Data_Out();
        }

        private void b_o24_Click(object sender, EventArgs e)
        {
            port2 = (byte)(port2 ^ 0x10); // Bit 4
            Port_Data_Out();
        }

        private void b_o25_Click(object sender, EventArgs e)
        {
            port2 = (byte)(port2 ^ 0x20); // Bit 5
            Port_Data_Out();
        }

        private void b_o26_Click(object sender, EventArgs e)
        {
            port2 = (byte)(port2 ^ 0x40); // Bit 6
            Port_Data_Out();
        }

        private void b_o27_Click(object sender, EventArgs e)
        {
            port2 = (byte)(port2 ^ 0x80); // Bit 7
            Port_Data_Out();
        }

        /// <summary>
        /// Port3 output Button Click
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void b_o30_Click(object sender, EventArgs e)
        {
            port3 = (byte)(port3 ^ 0x01); // Bit 0
            Port_Data_Out();
        }

        private void b_o31_Click(object sender, EventArgs e)
        {
            port3 = (byte)(port3 ^ 0x02); // Bit 1
            Port_Data_Out();
        }

        private void b_o32_Click(object sender, EventArgs e)
        {
            port3 = (byte)(port3 ^ 0x04); // Bit 2
            Port_Data_Out();
        }

        private void b_o33_Click(object sender, EventArgs e)
        {
            port3 = (byte)(port3 ^ 0x08); // Bit 3
            Port_Data_Out();
        }

        private void b_o34_Click(object sender, EventArgs e)
        {
            port3 = (byte)(port3 ^ 0x10); // Bit 4
            Port_Data_Out();
        }

        private void b_o35_Click(object sender, EventArgs e)
        {
            port3 = (byte)(port3 ^ 0x20); // Bit 5
            Port_Data_Out();
        }

        private void b_o36_Click(object sender, EventArgs e)
        {
            port3 = (byte)(port3 ^ 0x40); // Bit 6
            Port_Data_Out();
        }

        private void b_o37_Click(object sender, EventArgs e)
        {
            port3 = (byte)(port3 ^ 0x80); // Bit 7
            Port_Data_Out();
        }

        /// <summary>
        /// Input Port0 Set
        /// </summary>
        public void InputPort0_Set(byte Data)
        {
            byte bit = 1;
            int loops;

            for (loops = 0; loops < 8; loops++)
            {
                if ((Data & bit) == bit)
                {
                    ((Label)Port0_Labels[loops]).BackColor = bitons[0];  // Set Label color when ON
                }
                else
                {
                    ((Label)Port0_Labels[loops]).BackColor = bitoffs[0]; // Set Label color when OFF
                }
                bit <<= 1;
            }
        }

        /// <summary>
        /// Output Port1 Set
        /// </summary>
        public void OutputPort1_Set(byte Data)
        {
            byte bit = 1;
            int loops;

            for (loops = 0; loops < 8; loops++)
            {
                if ((Data & bit) == bit)
                {
                    ((Button)Port1_Buttons[loops]).BackColor = bitons[1];  // Set Button color of Port1 when ON
                }
                else
                {
                    ((Button)Port1_Buttons[loops]).BackColor = bitoffs[1]; // Set Button color of Port1 when OFF
                }
                bit <<= 1;
            }
        }

        /// <summary>
        /// Output Port2 Set
        /// </summary>
        public void OutputPort2_Set(byte Data)
        {
            byte bit = 1;
            int loops;

            for (loops = 0; loops < 8; loops++)
            {
                if ((Data & bit) == bit)
                {
                    ((Button)Port2_Buttons[loops]).BackColor = bitons[2];  // Set Button color of Port2 when ON
                }
                else
                {
                    ((Button)Port2_Buttons[loops]).BackColor = bitoffs[2]; // Set Button color of Port2 when OFF
                }
                bit <<= 1;
            }
        }

        /// <summary>
        /// Output Port3 Set
        /// </summary>
        public void OutputPort3_Set(byte Data)
        {
            byte bit = 1;
            int loops;

            for (loops = 0; loops < 8; loops++)
            {
                if ((Data & bit) == bit)
                {
                    ((Button)Port3_Buttons[loops]).BackColor = bitons[3];  // Set Button color of Port3 when ON
                }
                else
                {
                    ((Button)Port3_Buttons[loops]).BackColor = bitoffs[3]; // Set Button color of Port3 when OFF
                }
                bit <<= 1;
            }
            port3 = Data;
        }


        /// <summary>
        /// Display Port Data
        /// </summary>
        public void Disp_Port_Data()
        {
            if (portrd[0] != port0) // Port0 changes ?
            {
                port0 = portrd[0];
                InputPort0_Set(port0); // Port0 Data Display
            }

            if (portrd[1] == port1) // Port1 changes ?
            {
                if (port1s != port1)
                {
                    OutputPort1_Set(port1);  // Port1 Data Display
                    port1s = port1;
                }
            }
            else
            {
                port1 = portrd[1];
                OutputPort1_Set(port1);  // Port1 Data Display
                port1s = port1;
            }

            if (portrd[2] == port2) // Port2 changes ?
            {
                if (port2s != port2)
                {
                    OutputPort2_Set(port2);  // Port2 Data Display
                    port2s = port2;
                }
            }
            else
            {
                port2 = portrd[2];
                OutputPort2_Set(port2);  // Port2 Data Display
                port2s = port2;
            }

            if (portrd[3] == port3) // Port3 changes ?
            {
                if (port3s != port3)
                {
                    OutputPort3_Set(port3);  // Port3 Data Display
                    port3s = port3;
                }
            }
            else
            {
                port3 = portrd[3];
                OutputPort3_Set(port3);  // Port3 Data Display
                port3s = port3;
            }
        }
            
        /// <summary>
        /// Timer processing
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void timer1_Tick(object sender, EventArgs e)
        {
            switch (CommFlag)
            {
                case 0:
                    break;

                case 1:
                    Port_Data_Read();
                    Disp_Port_Data();
                    break;
            }

            Device_Error_Check();
        }
    }
}
