﻿using FTD2XX_NET;
using System.Threading;
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace MNET_STK_IO_Sample
{
    public class accessMNET
    {
        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Class / Table
        /// </summary>
        private clsFTDI hFTDI = new clsFTDI();

        //
        public byte[] PileUpBuffer = new byte[1024];

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Read status and interrupt status
        ///   sts ： Status
        ///   intsts ： Interrupt status
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterReadSts(ref uint sts, ref uint intsts)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            uint numBytesRead = 0;

            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh Status-low
            index++;
            dataBuffer[index] = 0x00; // AddrLow(0h)
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh Status-high
            index++;
            dataBuffer[index] = 0x01; // AddrLow(1h)
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh Interrupt Status-low
            index++;
            dataBuffer[index] = 0x02; // AddrLow(2h)
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh Interrupt Status-high
            index++;
            dataBuffer[index] = 0x03; // AddrLow(3h)
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            if (ftStatus == FTDI.FT_STATUS.FT_OK)
            {
                ftStatus = hFTDI.LSI_Read(ref dataBuffer, ref numBytesRead);
            }

            //
            sts = (uint)dataBuffer[(1 * 2)] * 256 + (uint)dataBuffer[0];
            intsts = (uint)dataBuffer[(3 * 2)] * 256 + (uint)dataBuffer[(2 * 2)];
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Read device information of address map
        ///   inf ： Device information(1 Device)
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterReadInf(short devNo, ref byte[] inf)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            uint numBytesRead = 0;
            byte num;

            num = (byte)devNo;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(0x78 + num); // AddrLow
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            if (ftStatus == FTDI.FT_STATUS.FT_OK)
            {
                ftStatus = hFTDI.LSI_Read(ref dataBuffer, ref numBytesRead);
            }

            //
            inf[num] = dataBuffer[0];
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Read all device information of address map
        ///   inf ： Device information(1 Device)
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterReadAllInf(ref byte[] inf)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            uint numBytesRead = 0;
            byte num;
            int loops;

            for (loops = 0; loops < 64; loops++)
            {
                num = (byte)loops;
                //
                dataBuffer[index] = 0x91; // FTDI-read command & address
                index++;
                dataBuffer[index] = 0x00; // AddrHigh
                index++;
                dataBuffer[index] = (byte)(0x78 + num); // AddrLow
                index++;

            }
            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            if (ftStatus == FTDI.FT_STATUS.FT_OK)
            {
                ftStatus = hFTDI.LSI_Read(ref dataBuffer, ref numBytesRead);
            }

            for (loops = 0; loops < 64; loops++)
            {
                //
                inf[loops] = dataBuffer[(loops * 2)];
                //
            }
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Read port data of address map
        ///   intsts ： Port data(1 Device)
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterReadPortD(short devNo, ref byte portA, ref byte portB, ref byte portC, ref byte portD)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            uint numBytesRead = 0;
            byte num;

            num = (byte)(devNo * 4);
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x01; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(num + 0x00); // AddrLow
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x01; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(num + 0x01); // AddrLow
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x01; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(num + 0x02); // AddrLow
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x01; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(num + 0x03); // AddrLow
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            if (ftStatus == FTDI.FT_STATUS.FT_OK)
            {
                ftStatus = hFTDI.LSI_Read(ref dataBuffer, ref numBytesRead);
            }

            //
            portA = dataBuffer[0];
            portB = dataBuffer[2];
            portC = dataBuffer[4];
            portD = dataBuffer[6];
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Read device information by command(2 Device)
        ///   0x6000:DevNo.1-0 0x6004:DevNo.3-2 ... 0x607C:DevNo.63-62
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdReadDevInf(short devNo, ref byte dataA, ref byte dataB)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            uint numBytesRead = 0;
            byte num;

            num = (byte)(devNo / 2);
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x00; // AddrLow
            index++;
            dataBuffer[index] = (byte)(num * 4); // CommandLow
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x01; // AddrLow
            index++;
            dataBuffer[index] = 0x60; // CommandHigh
            index++;
            // read ---------------------------------------------------
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x04; // AddrLow(devNo)
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x05; // AddrLow(devNo + 1)
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            if (ftStatus == FTDI.FT_STATUS.FT_OK)
            {
                ftStatus = hFTDI.LSI_Read(ref dataBuffer, ref numBytesRead);
            }

            //
            dataA = dataBuffer[0];
            dataB = dataBuffer[2];
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Read port data by command(1 Device)
        ///   0x6400:DevNo.0_Port1-0 0x6402:DevNo.0_Port3-2 ... 0x647E:DevNo.63_Port3-2
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdReadPortD(short devNo, int lh, ref byte portA, ref byte portB)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            uint numBytesRead = 0;
            byte num;

            num = (byte)devNo;
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x00; // AddrLow
            index++;
            if (lh == 0)
            {
                dataBuffer[index] = (byte)(num * 2); // CommandLow
                index++;
            }
            else
            {
                dataBuffer[index] = (byte)((num * 2) + 1); // CommandLow
                index++;
            }
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x01; // AddrLow
            index++;
            dataBuffer[index] = 0x64; // CommandHigh
            index++;
            // read ---------------------------------------------------
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x04; // AddrLow(devNo0-1 + 4)
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x05; // AddrLow(devNo2-3 + 4)
            index++;
            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            if (ftStatus == FTDI.FT_STATUS.FT_OK)
            {
                ftStatus = hFTDI.LSI_Read(ref dataBuffer, ref numBytesRead);
            }

            //
            portA = dataBuffer[0];
            portB = dataBuffer[2];
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Read attribute information of specified device by command
        ///   0x1300: DevNo.0 ... 0x133F: DevNo.63
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdReadDevAttribute(short devNo)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            byte num;

            num = (byte)devNo;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x00; // AddrLow
            index++;
            dataBuffer[index] = num; // CommandLow
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x01; // AddrLow
            index++;
            dataBuffer[index] = 0x13; // CommandHigh
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            return (ftStatus);
        }

        /////////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Acquisition of attribute information of specified device by command
        ///   0x1300: DevNo.0 ... 0x133F: DevNo.63
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdGetDevAttribute(short devNo, ref uint[] Attrdata)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            uint numBytesRead = 0;
            byte num;

            num = (byte)devNo;
            //
            // read ---------------------------------------------------
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x06; // AddrLow(bit7-0)
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x07; // AddrLow(bit15-8)
            index++;
            //
            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x06; // AddrLow(bit23-16)
            index++;

            dataBuffer[index] = 0x91; // FTDI-read command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x07; // AddrLow(bit31-24)
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            if(ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                goto END;
            }

            ftStatus = hFTDI.LSI_Read(ref dataBuffer, ref numBytesRead);
            if(ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                goto END;
            }

            //
            Attrdata[num] = (uint)dataBuffer[(3 * 2)] * 0x1000000 + (uint)dataBuffer[(2 * 2)] * 0x10000 + (uint)dataBuffer[(1 * 2)] * 0x100 + (uint)dataBuffer[0];
            //
END:
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Write device information of address map
        ///   inf ： Device information(1 Device)
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterWriteInf(short devNo, byte data)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            byte num;

            num = (byte)devNo;
            dataBuffer[index] = 0x93; // FTDI-write command & address & data
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(0x78 + devNo); // AddrLow
            index++;
            dataBuffer[index] = data; // Data
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Write port data of address map
        ///   intsts ： Port data(1 Device)
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterWritePortD(short devNo, byte port0, byte port1, byte port2, byte port3)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            byte num;

            num = (byte)(devNo * 4);
            dataBuffer[index] = 0x93; // FTDI-write command & address & data
            index++;
            dataBuffer[index] = 0x01; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(num + 0x00); // AddrLow
            index++;
            dataBuffer[index] = port0; // Data
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address & data
            index++;
            dataBuffer[index] = 0x01; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(num + 0x01); // AddrLow
            index++;
            dataBuffer[index] = port1; // Data
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address & data
            index++;
            dataBuffer[index] = 0x01; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(num + 0x02); // AddrLow
            index++;
            dataBuffer[index] = port2; // Data
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address & data
            index++;
            dataBuffer[index] = 0x01; // AddrHigh
            index++;
            dataBuffer[index] = (byte)(num + 0x03); // AddrLow
            index++;
            dataBuffer[index] = port3; // Data
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Write device information by command(2 Device)
        ///   0x5000:DevNo.1-0 0x5004:DevNo.3-2 ... 0x507E:DevNo.63-62
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdWriteDevInf(short devNo, byte dataA, byte dataB)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            byte num;

            num = (byte)((devNo / 2) * 2);
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x04; // AddrLow(devNo)
            index++;
            dataBuffer[index] = dataA; // Data
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x05; // AddrLow(devNo + 1)
            index++;
            dataBuffer[index] = dataB; // Data
            index++;
            //

            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x00; // AddrLow
            index++;
            dataBuffer[index] = (byte)(num * 2); // CommandLow
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x01; // AddrLow
            index++;
            dataBuffer[index] = 0x50; // CommandHigh
            index++;
            // write ---------------------------------------------------
            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Write port data by command(1 Device/ 4 Data)
        ///   0x5400:DevNo.0_Port1-0 0x5401:DevNo.0_Port3-2 ... 0x547F:DevNo.63_Port3-2
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdWritePortD(short devNo, int lh, byte portA, byte portB)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;
            byte num;

            num = (byte)devNo;
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x04; // AddrLow(devNo0-1 + 4)
            index++;
            dataBuffer[index] = portA;
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x05; // AddrLow(devNo2-3 + 4)
            index++;
            dataBuffer[index] = portB;
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x00; // AddrLow
            index++;
            if (lh == 0)
            {
                dataBuffer[index] = (byte)(num * 2); // CommandLow
                index++;
            }
            else
            {
                dataBuffer[index] = (byte)((num * 2) + 1); // CommandLow
                index++;
            }
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x01; // AddrLow
            index++;
            dataBuffer[index] = 0x54; // CommandHigh
            index++;
            // write ---------------------------------------------------
            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Write operation command software reset
        ///   0x0100: Software reset
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdWriteSoftwareReset()
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;

            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x00; // AddrLow
            index++;
            dataBuffer[index] = 0x00; // CommandLow
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x01; // AddrLow
            index++;
            dataBuffer[index] = 0x01; // CommandHigh
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Write operation commands to all devices in system communication
        ///   0x1000: System communication to all devices
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdWriteSystemComm()
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;

            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x00; // AddrLow
            index++;
            dataBuffer[index] = 0x00; // CommandLow
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x01; // AddrLow
            index++;
            dataBuffer[index] = 0x10; // CommandHigh
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Start writing of I/O communication of operation command
        ///   0x3000: Start I/O communication
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdWriteCyclicComm()
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;

            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x00; // AddrLow
            index++;
            dataBuffer[index] = 0x00; // CommandLow
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x01; // AddrLow
            index++;
            dataBuffer[index] = 0x30; // CommandHigh
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            return (ftStatus);
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// Stop writing of I/O communication of operation command
        ///   0x3100: Stop I/O communication
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS MNETCenterComdWriteStopCyclicComm()
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
            byte[] dataBuffer = new byte[1024];
            int index = 0;

            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x00; // AddrLow
            index++;
            dataBuffer[index] = 0x00; // CommandLow
            index++;
            //
            dataBuffer[index] = 0x93; // FTDI-write command & address
            index++;
            dataBuffer[index] = 0x00; // AddrHigh
            index++;
            dataBuffer[index] = 0x01; // AddrLow
            index++;
            dataBuffer[index] = 0x31; // CommandHigh
            index++;

            //
            ftStatus = hFTDI.LSI_Write(dataBuffer, index);
            //
            return (ftStatus);
        }
    }
}
