﻿using FTD2XX_NET;
using System.Threading;
using System.Diagnostics;

namespace MNET_STK_IO_Sample
{
    class clsFTDI
    {
        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// 
        /// </summary>
        public static FTDI ftHandle = new FTDI();

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// 
        /// </summary>
        /// <param name="description"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS LSI_Open(string description)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;

            ////////////////////////////////////////////////////////////////////
            // FTDI.OpenByDescription
            ftStatus = ftHandle.OpenByDescription(description);

            if (!ftHandle.IsOpen)
            {   // error
                Debug.WriteLine("Error: FTDI.penByDescription! [ " + ftStatus.ToString() + " ]");
                return ftStatus;
            }

            ////////////////////////////////////////////////////////////////////
            // FTDI.ResetDevice
            ftStatus = ftHandle.ResetDevice();

            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {   // error
                Debug.WriteLine("Error: FTDI.ResetDevice! [ " + ftStatus.ToString() + " ]");
                ftHandle.Close();
                return ftStatus;
            }

            ////////////////////////////////////////////////////////////////////
            // FTDI.SetTimeouts
            uint ReadTimeout = 1000;    // 1000ms
            uint WriteTimeout = 1000;   // 1000ms

            ftStatus = ftHandle.SetTimeouts(ReadTimeout, WriteTimeout);

            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {   // error
                Debug.WriteLine("Error: FTDI.SetTimeouts! [ " + ftStatus.ToString() + " ]");
                ftHandle.Close();
                return ftStatus;
            }

            ////////////////////////////////////////////////////////////////////
            // FTDI.SetBitMode (MCU Host Bus Emulation Mode)
            byte Mask = 0;
            byte BitMode = FTDI.FT_BIT_MODES.FT_BIT_MODE_MCU_HOST;

            ftStatus = ftHandle.SetBitMode(Mask, BitMode);

            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {   // error
                Debug.WriteLine("Error: FTDI.SetBitMode! [ " + ftStatus.ToString() + " ]");
                ftHandle.Close();
                return ftStatus;
            }

            ////////////////////////////////////////////////////////////////////
            // FTDI.Write (12MHz)
            byte[] dataBuffer = new byte[] { 0x8B };    // 12MHz
            int numBytesToWrite = 1;
            uint numBytesWritten = 0;

            ftStatus = ftHandle.Write(dataBuffer, numBytesToWrite, ref numBytesWritten);

            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {   // error
                Debug.WriteLine("Error: FTDI.Write! [ " + ftStatus.ToString() + " ]");
                return ftStatus;
            }

            ////////////////////////////////////////////////////////////////////
            return ftStatus;
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public FTDI.FT_STATUS LSI_Close()
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;

            ////////////////////////////////////////////////////////////////////
            // FTDI.Close
            ftStatus = ftHandle.Close();

            if (ftHandle.IsOpen)
            {   // error
                Debug.WriteLine("Error: FTDI.Close! [" + ftStatus.ToString() + "]");
                return ftStatus;
            }

            return ftStatus;
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// FTDI Write
        /// </summary>
        /// <param name="dataBuffer"></param>
        /// <param name="numBytesToWrite"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS LSI_Write(byte[] dataBuffer, int numBytesToWrite)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;

            ////////////////////////////////////////////////////////////////////
            // FTDI.Write
            uint numBytesWritten = 0;

            ftStatus = ftHandle.Write(dataBuffer, numBytesToWrite, ref numBytesWritten);

            ////////////////////////////////////////////////////////////////////
            // Error Check
            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {   // error
                Debug.WriteLine("Error: FTDI.Write! [ " + ftStatus.ToString() + " ]");
                return ftStatus;
            }

            if (numBytesToWrite != numBytesWritten)
            {   // error
                Debug.WriteLine(
                    "Error: FTDI.Write! [ numBytesToWrite: " + numBytesToWrite.ToString() +
                    " /= numBytesWritten: " + numBytesWritten.ToString() + " ]");
                return FTDI.FT_STATUS.FT_OTHER_ERROR;
            }

            ////////////////////////////////////////////////////////////////////
            return ftStatus;
        }

        ////////////////////////////////////////////////////////////////////
        /// <summary>
        /// FTDI Read
        /// </summary>
        /// <param name="data"></param>
        /// <param name="numBytesRead"></param>
        /// <returns></returns>
        public FTDI.FT_STATUS LSI_Read(ref byte[] dataBuffer, ref uint numBytesRead)
        {
            ////////////////////////////////////////////////////////////////////
            FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;

            ////////////////////////////////////////////////////////////////////
            // Read Queue Check
            uint RxQueue = 0;
            uint numBytesToRead = 0;

            do
            {
                Thread.Sleep(10);

                numBytesToRead = RxQueue;

                ftStatus = ftHandle.GetRxBytesAvailable(ref RxQueue);

                if (ftStatus != FTDI.FT_STATUS.FT_OK)
                {   // error
                    Debug.WriteLine("Error: FTDI.GetRxBytesAvailable! [" + ftStatus.ToString() + "]");
                    return ftStatus;
                }
            }
            while ((numBytesToRead != RxQueue) || (RxQueue == 0));

            ////////////////////////////////////////////////////////////////////
            // FTDI.Read
            do
            {
                Thread.Sleep(0);

                numBytesToRead = RxQueue;

                ftStatus = ftHandle.Read(dataBuffer, numBytesToRead, ref numBytesRead);

                if (ftStatus != FTDI.FT_STATUS.FT_OK)
                {   // error
                    Debug.WriteLine("Error: FTDI.Read! [" + ftStatus.ToString() + "]");
                    return ftStatus;
                }

                ftStatus = ftHandle.GetRxBytesAvailable(ref RxQueue);

                if (ftStatus != FTDI.FT_STATUS.FT_OK)
                {   // error
                    Debug.WriteLine("Error: FTDI.GetRxBytesAvailable! [" + ftStatus.ToString() + "]");
                    return ftStatus;
                }
            }
            while (RxQueue != 0);

            ////////////////////////////////////////////////////////////////////
            //numBytesRead = numBytesRead / 2;
            //
            //for (int i = 0; i < numBytesRead; i++)
            //{
            //    dataBuffer[i] = dataBuffer[i * 2];
            //}

            return ftStatus;
        }
    }
}
